/*
 * Decompiled with CFR 0.152.
 */
package cz.insophy.inplan.util.html;

import com.google.common.base.Preconditions;
import cz.insophy.inplan.util.html.HtmlPart;
import cz.insophy.inplan.util.html.HtmlTag;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class HtmlBuilder {
    public static List<HtmlPart> toHtmlParts(@Nonnull List<HtmlTag> tags) {
        Preconditions.checkNotNull(tags);
        ArrayList<HtmlPart> parts = new ArrayList<HtmlPart>();
        tags.forEach(t -> HtmlBuilder.parseTag(t, parts));
        return parts;
    }

    public static String toString(@Nonnull List<HtmlTag> tags) {
        Preconditions.checkNotNull(tags);
        return tags.stream().map(HtmlBuilder::parseTagToText).collect(Collectors.joining("\n"));
    }

    private static void parseTag(HtmlTag tag, List<HtmlPart> parts) {
        if (tag.isFtl()) {
            parts.add(new HtmlPart(true, tag.getName()));
            return;
        }
        if (tag.getChildren().isEmpty()) {
            parts.add(new HtmlPart(false, tag.getFront() + tag.getEnd()));
            return;
        }
        parts.add(new HtmlPart(false, tag.getFront()));
        tag.getChildren().forEach(t -> HtmlBuilder.parseTag(t, parts));
        parts.add(new HtmlPart(false, tag.getEnd()));
    }

    private static String parseTagToText(HtmlTag tag) {
        if (tag.isFtl()) {
            throw new IllegalStateException();
        }
        if (tag.getChildren().isEmpty()) {
            return tag.getFront() + tag.getEnd();
        }
        return tag.getFront() + tag.getChildren().stream().map(HtmlBuilder::parseTagToText).collect(Collectors.joining("\n")) + tag.getEnd();
    }
}

